#version 450 compatibility

//out vec2 texcoord;

flat out vec3 colorSunlight;
flat out vec3 colorSkylight;

#include "/lib/Head/Common.inc"

#ifdef CLOUDS_WEATHER
	flat out float cloudDynamicCovA;
	flat out float cloudDynamicCovB;
	flat out float cloudDynamicType;
#endif

uniform sampler2D noisetex;

uniform float nightVision;
uniform float wetness;
uniform float isLightningFlashing;
uniform float BiomeGreenShift;
uniform float worldTimeCounter;

uniform vec3 worldSunVector;
uniform vec3 worldLightVector;

uniform int moonPhase;

uniform vec2 screenPixelSize;

#include "/lib/Atmosphere/Atmosphere.glsl"

void main() {
	gl_Position = vec4(gl_Vertex.xy * (2.0 / TEMPORAL_UPSCALING) - 1.0, 0.0, 1.0);
	//texcoord = gl_Vertex.xy;

	colorSunlight = GetColorSunlight(worldSunVector);
	colorSkylight = SkyShading(vec3(0.0, 1.0, 0.0)) * oneMinus(BiomeGreenShift * 0.5);
	colorSkylight += maxOf(colorSkylight) * vec3(0.3, 1.0, 0.24) * BiomeGreenShift;

	#ifdef CLOUDS_WEATHER
		vec2 weatherMap = texture(noisetex, vec2(fract(worldTimeCounter * 1e-6))).yz;

		cloudDynamicCovA = saturate(sqr(abs(weatherMap.x - 0.45) * 9.0));
		cloudDynamicCovA *= cloudDynamicCovA * 0.8;
		cloudDynamicCovB = saturate(sqr(abs(weatherMap.y - 0.55) * 9.0));
		cloudDynamicCovB *= cloudDynamicCovB * 0.8;

		cloudDynamicType = saturate(1.0 - abs(weatherMap.x - 0.6) * 10.0);
		cloudDynamicType *= 2.0 - cloudDynamicType;
	#endif
}
